package nemosofts.voxradio.executor;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;

import nemosofts.voxradio.callback.Callback;
import nemosofts.voxradio.interfaces.HomeListener;
import nemosofts.voxradio.item.ItemCat;
import nemosofts.voxradio.item.ItemCountries;
import nemosofts.voxradio.item.ItemPodcasts;
import nemosofts.voxradio.item.ItemPost;
import nemosofts.voxradio.item.ItemRadio;
import nemosofts.voxradio.utils.ApplicationUtil;
import nemosofts.voxradio.utils.AsyncTaskExecutor;
import okhttp3.RequestBody;

public class LoadSearch extends AsyncTaskExecutor<String, String, String> {

    RequestBody requestBody;
    HomeListener homeListener;
    ArrayList<ItemPost> arrayListPost = new ArrayList<>();
    String message = "";

    private static final String TAG_POST_ID = "post_id";
    private static final String TAG_POST_TITLE = "post_title";
    private static final String TAG_POST_IMG = "post_image";

    public LoadSearch(HomeListener homeListener, RequestBody requestBody) {
        this.homeListener = homeListener;
        this.requestBody = requestBody;
    }

    @Override
    protected void onPreExecute() {
        homeListener.onStart();
        super.onPreExecute();
    }

    @Override
    protected String doInBackground(String strings) {
        try {
            String json = ApplicationUtil.responsePost(Callback.API_URL, requestBody);
            JSONObject mainJson = new JSONObject(json);
            JSONObject jsonObjectRoot = mainJson.getJSONObject(Callback.TAG_ROOT);

            ItemPost itemPost;
            String postTitle;
            String postType;
            String postId;

            if (jsonObjectRoot.has("radio_list")) {
                ArrayList<ItemRadio> arrayListRadio = new ArrayList<>();

                JSONArray jsonArrayAlbums = jsonObjectRoot.getJSONArray("radio_list");

                postId = "1";
                postTitle = "Radio";
                postType = "radio";
                itemPost = new ItemPost(postId, postTitle, postType, false);

                for (int i = 0; i < jsonArrayAlbums.length(); i++) {
                    JSONObject objJson = jsonArrayAlbums.getJSONObject(i);

                    String id = objJson.getString("id");
                    String catId = objJson.getString("cat_id");
                    String radioTitle = objJson.getString("radio_title");
                    String radioURL = objJson.getString("radio_url");
                    String image = objJson.getString("image").replace(" ", "%20");
                    if (image.isEmpty()) {
                        image = "null";
                    }
                    String averageRating = objJson.getString("averageRating");
                    String totalRate = objJson.getString("totalRate");
                    String catName = objJson.getString("category_name");
                    String totalViews = objJson.getString("total_views");
                    boolean isPremium = objJson.getBoolean("is_premium");
                    boolean isFav = objJson.getBoolean("is_favourite");

                    ItemRadio objItem = new ItemRadio(id, catId, radioTitle, radioURL, image,
                            averageRating, totalRate, totalViews, catName ,isPremium, isFav);
                    arrayListRadio.add(objItem);
                }
                itemPost.setArrayListRadio(arrayListRadio);
                arrayListPost.add(itemPost);
            }

            if (jsonObjectRoot.has("category_list")) {
                ArrayList<ItemCat> arrayListCat = new ArrayList<>();

                JSONArray jsonArrayCategories = jsonObjectRoot.getJSONArray("category_list");

                postId = "2";
                postTitle = "Categories";
                postType = "category";
                itemPost = new ItemPost(postId, postTitle, postType, false);

                for (int i = 0; i < jsonArrayCategories.length(); i++) {
                    JSONObject objJson = jsonArrayCategories.getJSONObject(i);

                    String id = objJson.getString(TAG_POST_ID);
                    String name = objJson.getString(TAG_POST_TITLE);
                    String image = objJson.getString(TAG_POST_IMG).replace(" ", "%20");
                    if (image.isEmpty()) {
                        image = "null";
                    }

                    ItemCat itemCat = new ItemCat(id, name, image);
                    arrayListCat.add(itemCat);
                }
                itemPost.setArrayListCategories(arrayListCat);
                arrayListPost.add(itemPost);
            }

            if (jsonObjectRoot.has("countries_list")) {
                ArrayList<ItemCountries> arrayListCountries = new ArrayList<>();

                JSONArray jsonArrayCountries = jsonObjectRoot.getJSONArray("countries_list");

                postId = "3";
                postTitle = "Countries";
                postType = "countries";
                itemPost = new ItemPost(postId, postTitle, postType, false);

                for (int i = 0; i < jsonArrayCountries.length(); i++) {
                    JSONObject objJson = jsonArrayCountries.getJSONObject(i);

                    String id = objJson.getString(TAG_POST_ID);
                    String name = objJson.getString(TAG_POST_TITLE);
                    String image = objJson.getString(TAG_POST_IMG).replace(" ", "%20");
                    if (image.isEmpty()) {
                        image = "null";
                    }

                    ItemCountries itemCountries = new ItemCountries(id, name, image);
                    arrayListCountries.add(itemCountries);
                }
                itemPost.setArrayListCountries(arrayListCountries);
                arrayListPost.add(itemPost);
            }

            if (jsonObjectRoot.has("podcasts_list")) {
                ArrayList<ItemPodcasts> arrayListCasts= new ArrayList<>();

                JSONArray jsonArrayCasts = jsonObjectRoot.getJSONArray("podcasts_list");

                postId = "4";
                postTitle = "Podcasts";
                postType = "podcasts";
                itemPost = new ItemPost(postId, postTitle, postType, false);

                for (int i = 0; i < jsonArrayCasts.length(); i++) {
                    JSONObject objJson = jsonArrayCasts.getJSONObject(i);

                    String id = objJson.getString(TAG_POST_ID);
                    String name = objJson.getString(TAG_POST_TITLE);
                    String image = objJson.getString(TAG_POST_IMG).replace(" ", "%20");
                    if (image.isEmpty()) {
                        image = "null";
                    }

                    ItemPodcasts itemPodcasts = new ItemPodcasts(id, name, image);
                    arrayListCasts.add(itemPodcasts);
                }
                itemPost.setArrayListPodcasts(arrayListCasts);
                arrayListPost.add(itemPost);
            }

            return "1";
        } catch (Exception e) {
            return "0";
        }
    }

    @Override
    protected void onPostExecute(String s) {
        homeListener.onEnd(s, message, arrayListPost);
    }
}